IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_SAI_EST_WMS_ENT_INSERIR_CPL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_SAI_EST_WMS_ENT_INSERIR_CPL]
GO
GO
GO
GO
CREATE PROCEDURE P_EST_NF_SAI_EST_WMS_ENT_INSERIR_CPL @CD_CTR	INT
AS
BEGIN


--ESSE PARAMETRO FOI NECESSARIO POR CONTA DA LIMITACAO DO DELAGE QUE NAO ACEITA NOTAS MULTIPLAS PARA UM MESMO PEDIDO
DECLARE @NAO_PERMITE_MULT_NF_TRANF_WMS INT
SET @NAO_PERMITE_MULT_NF_TRANF_WMS = 0
SET @NAO_PERMITE_MULT_NF_TRANF_WMS = COALESCE((SELECT CASE WHEN ISNUMERIC(VALOR) = 1 THEN VALOR ELSE 0 END FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'NAO_PERMITE_MULT_NF_TRANF_WMS'), 0)


--SE O PARMETRO ESTIVER ATIVADO (NAO ACEITA MULTIPLAS NOTAS), ENTRA NA PARTE QUE GRAVA 1 NOTA POR PEDIDO WMS
IF @NAO_PERMITE_MULT_NF_TRANF_WMS = 1
BEGIN

	DECLARE @CD_EMP INT
	DECLARE @CD_FILIAL INT
	DECLARE @CD_NF INT

	DECLARE 
		CURSOR_NOTAS
	CURSOR FOR
	SELECT
		CD_EMP,
		CD_FILIAL,
		CD_NF
	FROM
		EST_NF_SAI_LOTE_ENVIO_WMS_CPL
	WHERE
		CD_CTR = @CD_CTR

	OPEN CURSOR_NOTAS

	FETCH NEXT FROM CURSOR_NOTAS INTO @CD_EMP, @CD_FILIAL, @CD_NF

	WHILE @@FETCH_STATUS = 0
	BEGIN
		
		-------------------------------------------------------------------------------
		--Gravando o cabealho da integrao
		-------------------------------------------------------------------------------
		INSERT INTO EST_WMS_ENT (DT_PED, 
								 CD_USU, 
								 DT_CAD, 
								 DT_ULT_ALT, 
								 STS_PED, 
								 CD_DEST_ORIG, 
								 NM_DEST_ORIG, 
								 TIPO_DOCUMENTO,
								 CD_DEPO_DEST)
		SELECT
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD AS DT_PED, 
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_USU, 
			EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD, 
			NULL AS DT_ULT_ALT, 
			0 AS STS_PED, 
			CASE WHEN V_EST_NF_SAI_CAB.DEST_ORIG=0 THEN  --Cliente
				CAST ('0' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			WHEN DEST_ORIG=1 THEN --Fornecedor
				CAST ('1' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			WHEN DEST_ORIG=2 THEN --Filial
				CAST ('2' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			END AS CD_FORN,
			V_EST_NF_SAI_CAB.NM_FANT AS NM_DEST_ORIG, 
			1 AS TIPO_DOCUMENTO, 
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_FILIAL AS CD_DEPO_DEST
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL
			INNER JOIN V_EST_NF_SAI_CAB ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = V_EST_NF_SAI_CAB.CD_EMP AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = V_EST_NF_SAI_CAB.CD_FILIAL AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = V_EST_NF_SAI_CAB.CD_NF 
			INNER JOIN EST_NF_SAI_LOTE_ENVIO_WMS ON 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = @CD_EMP
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = @CD_FILIAL
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = @CD_NF

		
		-------------------------------------------------------------------------------
		--Somando os produto das notas fiscais do lote
		--Gravando os itens da integrao
		-------------------------------------------------------------------------------
		INSERT INTO 
			EST_WMS_ENT_IT (CD_PED_WMS, CD_PROD, LOTE, QT_PROD, CD_EMP, DT_FABRIC, DT_VALID)
		SELECT        
			IDENT_CURRENT('EST_WMS_ENT'),
			EST_NF_SAI_IT.CD_PROD, 
			ISNULL(EST_PROD_CPL_LOTE.NR_LOTE,'ND') AS NR_LOTE, 
			SUM(ISNULL(EST_NF_SAI_IT_EST_PROD_CPL_LOTE.QTDE_PROD,EST_NF_SAI_IT.QT_IT)) AS QT_IT, 
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP,
			EST_PROD_CPL_LOTE.DT_FABR,
			EST_PROD_CPL_LOTE.DT_VALID
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL 
			INNER JOIN EST_NF_SAI_IT ON 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = EST_NF_SAI_IT.CD_EMP AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = EST_NF_SAI_IT.CD_NF 
			LEFT OUTER JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE ON 
				EST_NF_SAI_IT.CD_EMP = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP AND 
				EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND 
				EST_NF_SAI_IT.CD_NF = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF AND 
				EST_NF_SAI_IT.CD_PROD = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD AND 
				EST_NF_SAI_IT.CD_IT = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_IT 
			LEFT OUTER JOIN EST_PROD_CPL_LOTE ON 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP AND 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
		WHERE        
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = @CD_CTR
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = @CD_EMP
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = @CD_FILIAL
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = @CD_NF
		GROUP BY
			EST_NF_SAI_IT.CD_PROD, 
			EST_PROD_CPL_LOTE.NR_LOTE, 
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP,
			EST_PROD_CPL_LOTE.DT_FABR,
			EST_PROD_CPL_LOTE.DT_VALID

		-------------------------------------------------------------------------------
		--Gravando relacionamento notas fiscais da integracao
		-------------------------------------------------------------------------------
		INSERT INTO EST_NF_SAI_EST_WMS_ENT(CD_EMP,
										   CD_FILIAL_ORIG,
										   CD_NF_ORIG,
										   CD_PED_WMS,
										   DT_CAD,
										   CD_MOV_OP,
										   CD_ORIG,
										   DEST_ORIG,
										   CD_USU,
										   NM_ORIG)
		SELECT
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.CD_EMP,
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL,
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF,
			IDENT_CURRENT('EST_WMS_ENT') AS CD_PED_WMS,
			EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD,
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_MOV_OP,
			V_EST_NF_SAI_CAB.CD_CLI,
			V_EST_NF_SAI_CAB.CD_CLI AS DEST_ORIG,
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_USU,
			PRC_FILIAL.NM_FANT
		FROM
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL
			INNER JOIN V_EST_NF_SAI_CAB ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = V_EST_NF_SAI_CAB.CD_EMP AND
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = V_EST_NF_SAI_CAB.CD_FILIAL AND
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = V_EST_NF_SAI_CAB.CD_NF
			INNER JOIN EST_NF_SAI_LOTE_ENVIO_WMS ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR
			INNER JOIN PRC_FILIAL ON
				EST_NF_SAI_LOTE_ENVIO_WMS.CD_EMP= PRC_FILIAL.CD_EMP AND
				EST_NF_SAI_LOTE_ENVIO_WMS.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = @CD_EMP
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = @CD_FILIAL
			AND EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = @CD_NF

		-------------------------------------------------------------------------------
		--Gravando relacionamento do lote com a integracao
		-------------------------------------------------------------------------------
		INSERT INTO EST_NF_SAI_LOTE_ENVIO_WMS_EST_WMS_ENT(CD_CTR, 
														  CD_PED_WMS)
		SELECT        
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR,
			IDENT_CURRENT('EST_WMS_ENT') AS CD_PED_WMS
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR
		

		FETCH NEXT FROM CURSOR_NOTAS INTO @CD_EMP, @CD_FILIAL, @CD_NF

	END

	CLOSE CURSOR_NOTAS
	DEALLOCATE CURSOR_NOTAS


END ELSE
BEGIN

		-------------------------------------------------------------------------------
		--Gravando o cabealho da integrao
		-------------------------------------------------------------------------------
		INSERT INTO EST_WMS_ENT (DT_PED, 
								 CD_USU, 
								 DT_CAD, 
								 DT_ULT_ALT, 
								 STS_PED, 
								 CD_DEST_ORIG, 
								 NM_DEST_ORIG, 
								 TIPO_DOCUMENTO,
								 CD_DEPO_DEST)
		SELECT
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD AS DT_PED, 
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_USU, 
			EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD, 
			NULL AS DT_ULT_ALT, 
			0 AS STS_PED, 
			CASE WHEN V_EST_NF_SAI_CAB.DEST_ORIG=0 THEN  --Cliente
				CAST ('0' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			WHEN DEST_ORIG=1 THEN --Fornecedor
				CAST ('1' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			WHEN DEST_ORIG=2 THEN --Filial
				CAST ('2' + RIGHT('00000000' + CAST(CD_CLI AS VARCHAR), 8) AS NUMERIC) 
			END AS CD_FORN,
			V_EST_NF_SAI_CAB.NM_FANT AS NM_DEST_ORIG, 
			1 AS TIPO_DOCUMENTO, 
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_FILIAL AS CD_DEPO_DEST
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL
			INNER JOIN V_EST_NF_SAI_CAB ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = V_EST_NF_SAI_CAB.CD_EMP AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = V_EST_NF_SAI_CAB.CD_FILIAL AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = V_EST_NF_SAI_CAB.CD_NF 
			INNER JOIN EST_NF_SAI_LOTE_ENVIO_WMS ON 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR

		
		-------------------------------------------------------------------------------
		--Somando os produto das notas fiscais do lote
		--Gravando os itens da integrao
		-------------------------------------------------------------------------------
		INSERT INTO 
			EST_WMS_ENT_IT (CD_PED_WMS, CD_PROD, LOTE, QT_PROD, CD_EMP, DT_FABRIC, DT_VALID)
		SELECT        
			IDENT_CURRENT('EST_WMS_ENT'),
			EST_NF_SAI_IT.CD_PROD, 
			ISNULL(EST_PROD_CPL_LOTE.NR_LOTE,'ND') AS NR_LOTE, 
			SUM(ISNULL(EST_NF_SAI_IT_EST_PROD_CPL_LOTE.QTDE_PROD,EST_NF_SAI_IT.QT_IT)) AS QT_IT, 
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP,
			EST_PROD_CPL_LOTE.DT_FABR,
			EST_PROD_CPL_LOTE.DT_VALID
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL 
			INNER JOIN EST_NF_SAI_IT ON 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = EST_NF_SAI_IT.CD_EMP AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND 
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = EST_NF_SAI_IT.CD_NF 
			LEFT OUTER JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE ON 
				EST_NF_SAI_IT.CD_EMP = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP AND 
				EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND 
				EST_NF_SAI_IT.CD_NF = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF AND 
				EST_NF_SAI_IT.CD_PROD = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD AND 
				EST_NF_SAI_IT.CD_IT = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_IT 
			LEFT OUTER JOIN EST_PROD_CPL_LOTE ON 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP AND 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND 
				EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
		WHERE        
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = @CD_CTR
		GROUP BY
			EST_NF_SAI_IT.CD_PROD, 
			EST_PROD_CPL_LOTE.NR_LOTE, 
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP,
			EST_PROD_CPL_LOTE.DT_FABR,
			EST_PROD_CPL_LOTE.DT_VALID

		-------------------------------------------------------------------------------
		--Gravando relacionamento notas fiscais da integracao
		-------------------------------------------------------------------------------
		INSERT INTO EST_NF_SAI_EST_WMS_ENT(CD_EMP,
										   CD_FILIAL_ORIG,
										   CD_NF_ORIG,
										   CD_PED_WMS,
										   DT_CAD,
										   CD_MOV_OP,
										   CD_ORIG,
										   DEST_ORIG,
										   CD_USU,
										   NM_ORIG)
		SELECT
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.CD_EMP,
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL,
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF,
			IDENT_CURRENT('EST_WMS_ENT') AS CD_PED_WMS,
			EST_NF_SAI_LOTE_ENVIO_WMS.DT_CAD,
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_MOV_OP,
			V_EST_NF_SAI_CAB.CD_CLI,
			V_EST_NF_SAI_CAB.CD_CLI AS DEST_ORIG,
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_USU,
			PRC_FILIAL.NM_FANT
		FROM
			EST_NF_SAI_LOTE_ENVIO_WMS_CPL
			INNER JOIN V_EST_NF_SAI_CAB ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_EMP = V_EST_NF_SAI_CAB.CD_EMP AND
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_FILIAL = V_EST_NF_SAI_CAB.CD_FILIAL AND
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_NF = V_EST_NF_SAI_CAB.CD_NF
			INNER JOIN EST_NF_SAI_LOTE_ENVIO_WMS ON
				EST_NF_SAI_LOTE_ENVIO_WMS_CPL.CD_CTR = EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR
			INNER JOIN PRC_FILIAL ON
				EST_NF_SAI_LOTE_ENVIO_WMS.CD_EMP= PRC_FILIAL.CD_EMP AND
				EST_NF_SAI_LOTE_ENVIO_WMS.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR

		-------------------------------------------------------------------------------
		--Gravando relacionamento do lote com a integracao
		-------------------------------------------------------------------------------
		INSERT INTO EST_NF_SAI_LOTE_ENVIO_WMS_EST_WMS_ENT(CD_CTR, 
														  CD_PED_WMS)
		SELECT        
			DISTINCT EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR,
			IDENT_CURRENT('EST_WMS_ENT') AS CD_PED_WMS
		FROM            
			EST_NF_SAI_LOTE_ENVIO_WMS
		WHERE
			EST_NF_SAI_LOTE_ENVIO_WMS.CD_CTR = @CD_CTR
END
END	